#include "scripts.h"
#include "Reborn.h"

void Reborn_Game_Manager::Created(GameObject * obj)
{
	MMK2lim = 0;
	Cyborglim = 0;
}
void Reborn_Game_Manager::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&MMK2lim);
	Auto_Save_Variable(1,4,&Cyborglim);
}

void Reborn_Game_Manager::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	GameObject * send;
	int msg;
	int prm;
	msg = 3054;
	prm = 0;
	send = sender;
	//1015 is inc MMK2, 1025 Cyborg inc, 1016 is dec MMK2, 1026 is dec Cyborg
	if (message == 1015)
	{
		MMK2lim++;
		if (MMK2lim > 1)
		{
			Commands->Send_Custom_Event(obj,sender,msg,prm,0);
		}
		else
			Commands->Create_2D_Sound("MammothMk2Create");
	}
	if (message == 1016)
	{
		MMK2lim--;
		Commands->Create_2D_Sound("MammothMk2Death");
	}
	if (message == 1025)
	{
		Cyborglim++;
		if (Cyborglim > 1)
			Commands->Send_Custom_Event(obj,sender,msg,prm,0);
		else
			Commands->Create_2D_Sound("CommandoCreate");
	}
	if (message == 1026)
	{
		Cyborglim--;
		Commands->Create_2D_Sound("CommandoDeath");
	}
}
void Reborn_MMK2::Created(GameObject * obj)
{
	GameObject * send;
	int msg;
	int prm;
	msg = 1015;
	prm = 0;
	send = Commands->Find_Object(Get_Int_Parameter("GameManager_ID"));
	Commands->Send_Custom_Event(obj,send,msg,prm,0);
}
void Reborn_MMK2::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * send;
	int msg;
	int prm;
	msg = 1016;
	prm = 0;
	send = Commands->Find_Object(Get_Int_Parameter("GameManager_ID"));
	Commands->Send_Custom_Event(obj,send,msg,prm,0);
}
void Reborn_MMK2::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	Vector3 v;
	v = Commands->Get_Position(obj);
	if (message == 3054)
	{
		Commands->Give_Money(obj,Get_Float_Parameter("MoneyToReturn"),false);
		Commands->Create_Explosion(Get_Parameter("Explosion_Preset_Name"),v,0);
	}
}
void Reborn_Cyborg::Created(GameObject * obj)
{
	GameObject * send;
	int msg;
	int prm;
	msg = 1025;
	prm = 0;
	send = Commands->Find_Object(Get_Int_Parameter("GameManager_ID"));
	Commands->Send_Custom_Event(obj,send,msg,prm,0);
}
void Reborn_Cyborg::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	Vector3 v;
	v = Commands->Get_Position(obj);
	if (message == 3054)
	{
		Commands->Give_Money(obj,Get_Float_Parameter("MoneyToReturn"),false);
		Commands->Create_Explosion(Get_Parameter("Explosion_Preset_Name"),v,0);
	}
}
void Reborn_Cyborg::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * send;
	int msg;
	int prm;
	msg = 1026;
	prm = 0;
	send = Commands->Find_Object(Get_Int_Parameter("GameManager_ID"));
	Commands->Send_Custom_Event(obj,send,msg,prm,0);
}
//Reborn Deployable Vehicle
void Reborn_Deployable_Vehicle::Created(GameObject * obj)
{
	pilotID = 0;
}
void Reborn_Deployable_Vehicle::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if(message == CUSTOM_EVENT_VEHICLE_ENTER)
	{
		if(pilotID == 0)
		{
			pilotID = Commands->Get_ID(sender);
		}
	}
	if(message == CUSTOM_EVENT_VEHICLE_EXIT)
	{
		if(pilotID == Commands->Get_ID(sender))
		{
			pilotID = 0;
		}
	}
}
void Reborn_Deployable_Vehicle::Damaged(GameObject * obj,GameObject * damager,float damage)
{
	const char* preset;
	GameObject * npre;
	Vector3 pos;
	float health;
	float facing;
	if ((damager == Commands->Find_Object(pilotID)) && (damager != NULL))
	{
		preset = Get_Parameter("Animated_Preset");
		pos = Commands->Get_Position(obj);
		health = Commands->Get_Health(obj);
		npre = Commands->Create_Object(preset,pos);
		Commands->Set_Health(npre,health);
		health = Commands->Get_Shield_Strength(obj);
		Commands->Set_Shield_Strength(npre,health);
		facing = Commands->Get_Facing(obj);
		Commands->Set_Facing(npre,facing);
 		preset = Get_Parameter("Explosion_Preset");
		Commands->Create_Explosion(preset,pos,0);
	}
}
void Reborn_Deployable_Vehicle::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&pilotID);
}
//Reborn Deployable Vehicle Animation
void Reborn_Deploy_Animation::Created(GameObject * obj)
{
	Commands->Start_Timer(obj, this,Get_Float_Parameter("Time_Till_Death") , 1);
}
void Reborn_Deploy_Animation::Timer_Expired(GameObject * obj,int number)
{
	const char* preset;
	GameObject * npre;
	Vector3 pos;
	float health;
	float facing;
	preset = Get_Parameter("Deployed_Tank_Preset");
	pos = Commands->Get_Position(obj);
	health = Commands->Get_Health(obj);
	npre = Commands->Create_Object(preset,pos);
	Commands->Set_Health(npre,health);
	health = Commands->Get_Shield_Strength(obj);
	Commands->Set_Shield_Strength(npre,health);
	facing = Commands->Get_Facing(obj);
	Commands->Set_Facing(npre,facing);
 	preset = Get_Parameter("Explosion_Preset");
	Commands->Create_Explosion(preset,pos,0);
}
//Reborn MMK2 Turret Script
void Reborn_MMK2_Turret_Spawn::Created(GameObject * obj)
{
	Vector3 sp;
	GameObject *object;
	sp.X = 0;
	sp.Y = 0;
	sp.Z = 0;
	object = Commands->Create_Object(Get_Parameter("Turret_Preset"),sp);
	Commands->Attach_To_Object_Bone(object,obj,Get_Parameter("Bone_Name"));
	turID = Commands->Get_ID(object);
}
void Reborn_MMK2_Turret_Spawn::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&turID);
}
void Reborn_MMK2_Turret_Spawn::Killed(GameObject * obj,GameObject * shooter)
{
	Vector3 tmb;
	tmb = Commands->Get_Bone_Position(obj,Get_Parameter("Bone_Name"));
	Commands->Create_Explosion(Get_Parameter("Explosion_Preset"),tmb,0);
}
//Reborn Diggable Vehicle
void Reborn_Diggable_Vehicle::Created(GameObject * obj)
{
	pilotID = 0;
	ug = 0;
}
void Reborn_Diggable_Vehicle::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if(message == CUSTOM_EVENT_VEHICLE_ENTER)
	{
		if(pilotID == 0)
		{
			pilotID = Commands->Get_ID(sender);
		}
	}
	if(message == CUSTOM_EVENT_VEHICLE_EXIT)
	{
		if(pilotID == Commands->Get_ID(sender))
		{
			pilotID = 0;
		}
	}
}
void Reborn_Diggable_Vehicle::Damaged(GameObject * obj,GameObject * damager,float damage)
{
	Vector3 vpos;
	if ((damager != Commands->Find_Object(pilotID)) || (damager == NULL))
		return;
	vpos = Commands->Get_Position(obj);
	if (ug == 0)
	{
		vpos.Z = vpos.Z - Get_Float_Parameter("Z_Hieght_Adjust");
		ug = 1;
	}
	else
	{
		vpos.Z = vpos.Z + Get_Float_Parameter("Z_Hieght_Adjust");
		ug = 0;
	}
	Commands->Set_Position(obj,vpos);
}

void Reborn_Diggable_Vehicle::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&pilotID);
	Auto_Save_Variable(1,4,&ug);
}

void Reborn_PlaySound_OnCreate::Created(GameObject * obj)
{
	Commands->Create_2D_Sound(Get_Parameter("Sound_Preset_Name"));
}

//Reborn Diggable Vehicle Animated
void Reborn_Diggable_Vehicle_Animated::Created(GameObject * obj)
{
	pilotID = 0;
	ug = 0;
}
void Reborn_Diggable_Vehicle_Animated::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if(message == CUSTOM_EVENT_VEHICLE_ENTER)
	{
		if(pilotID == 0)
		{
			pilotID = Commands->Get_ID(sender);
		}
	}
	if(message == CUSTOM_EVENT_VEHICLE_EXIT)
	{
		if(pilotID == Commands->Get_ID(sender))
		{
			pilotID = 0;
		}
	}
}
void Reborn_Diggable_Vehicle_Animated::Damaged(GameObject * obj,GameObject * damager,float damage)
{
	if ((damager != Commands->Find_Object(pilotID)) || (damager == NULL))
		return;
	ActionParamsStruct aps;
	if (ug == 0)
		aps.Set_Animation(Get_Parameter("Dig_Animation"),false);
	if (ug == 1)
		aps.Set_Animation(Get_Parameter("Surface_Animation"),false);
	Commands->Action_Play_Animation(0,aps);
}

void Reborn_Diggable_Vehicle_Animated::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	Vector3 vpos;
	vpos = Commands->Get_Position(obj);
	if (ug == 0)
	{
		vpos.Z = vpos.Z - Get_Float_Parameter("Z_Hieght_Adjust");
		ug = 1;
	}
	else
	{
		vpos.Z = vpos.Z + Get_Float_Parameter("Z_Hieght_Adjust");
		ug = 0;
	}
	Commands->Set_Position(obj,vpos);
}

void Reborn_Diggable_Vehicle_Animated::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&pilotID);
	Auto_Save_Variable(1,4,&ug);
}
ScriptRegistrant<Reborn_Game_Manager> Reborn_Game_Manager_Registrant ("Reborn_Game_Manager","");
ScriptRegistrant<Reborn_MMK2> Reborn_MMK2_Registrant ("Reborn_MMK2","GameManager_ID:int,Explosion_Preset_Name:string,MoneyToReturn:float");
ScriptRegistrant<Reborn_Cyborg>Reborn_Cyborg_Registrant ("Reborn_Cyborg","GameManager_ID:int,Explosion_Preset_Name:string,MoneyToReturn:float");
ScriptRegistrant<Reborn_Deployable_Vehicle> Reborn_Deployable_Vehicle_Registrant ("Reborn_Deployable_Vehicle","Animated_Preset:string,Explosion_Preset:string");
ScriptRegistrant<Reborn_Deploy_Animation> Reborn_Deploy_Animation_Registrant ("Reborn_Deploy_Animation","Time_Till_Death:float,Deployed_Tank_Preset:string,Explosion_Preset:string");
ScriptRegistrant<Reborn_MMK2_Turret_Spawn> Reborn_MMK2_Turret_Spawn_Registrant ("Reborn_MMK2_Turret_Spawn","Turret_Preset:string,Bone_Name=Tur_Mount:string,Explosion_Preset:string");
ScriptRegistrant<Reborn_Diggable_Vehicle> Reborn_Diggable_Vehicle_Registrant ("Reborn_Diggable_Vehicle","Mode:int,Dig_Delay:float,Z_Hieght_Adjust:float");
ScriptRegistrant<Reborn_PlaySound_OnCreate> Reborn_PlaySound_OnCreate_Registrant ("Reborn_PlaySound_OnCreate","Sound_Preset_Name=BLAH!:string");
ScriptRegistrant<Reborn_Diggable_Vehicle_Animated> Reborn_Diggable_Vehicle_Animated_Registrant ("Reborn_Diggable_Vehicle_Animated","Z_Hieght_Adjust:float,Dig_Animation:string,Surface_Animation:string");
